<?php include 'includes/header.php';
include "fungsi.php"; ?>

<div class="container mx-auto px-4 py-16">
    <h1 class="text-4xl font-bold mb-8">Dokumen Pelaksanaan</h1>

    <div class="p-6 bg-gray-100 min-h-screen">
        <div class="bg-white rounded-md shadow-md p-4">
            <!-- Filter and Search -->
            <div class="flex justify-between items-center mb-4">
                <div>
                    <label for="entries" class="block text-sm font-medium text-gray-700">Show</label>
                    <select id="entries" class="mt-1 block w-20 rounded-md border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                </div>
                <div>
                    <label for="search" class="block text-sm font-medium text-gray-700">Search:</label>
                    <input type="text" id="search" class="mt-1 block w-64 rounded-md border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm">
                </div>
            </div>

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider max-w-[5px]">No</th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider max-w-[200px]">Nama Dokumen</th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider max-w-[500px]">Deskripsi</th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider max-w-[100px]">Tahun Terbit</th>
                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider max-w-[100px]">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php
                        // Pagination Logic
                        $limit = isset($_GET['limit']) ? $_GET['limit'] : 10;
                        $page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $offset = ($page - 1) * $limit;

                        $total_query = "SELECT COUNT(*) AS total FROM dokumen where 
                        jenis_dokumen='formulir' or jenis_dokumen='implementasi'";
                        $total_result = mysqli_query($conn, $total_query);
                        $total_row = mysqli_fetch_assoc($total_result);
                        $total_records = $total_row['total'];
                        $total_pages = ceil($total_records / $limit);

                        $query = "SELECT * FROM dokumen where 
                        jenis_dokumen='formulir' or jenis_dokumen='implementasi' LIMIT $limit OFFSET $offset";
                        $result = mysqli_query($conn, $query);
                        $no = $offset + 1;

                        while ($row = mysqli_fetch_assoc($result)) {
                        ?>
                           <tr>
    <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-700 max-w-[5px]"><?= $no ?></td>
    <td class="px-4 py-2 whitespace-normal text-sm text-gray-700 break-words max-w-[200px]"><?= $row['nama_dokumen'] ?></td>
    <td class="px-4 py-2 whitespace-normal text-sm text-gray-700 break-words max-w-[500px]"><?= $row['deskripsi'] ?></td>
    <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-700 max-w-[100px]"><?= $row['tahun_terbit'] ?></td>
    <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-700 max-w-[100px]">
        <a href='<?= $row['link_dokumen'] ?>' target="_blank">
            <button class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-2 rounded text-xs">View</button>
        </a>
    </td>
</tr>
                        <?php
                            $no++;
                        }
                        ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <!-- Pagination -->
            <div class="flex justify-between items-center mt-4">
                <div class="text-sm text-gray-700">
                    Showing <?php echo $offset + 1; ?> to <?php echo min($offset + $limit, $total_records); ?> of <?php echo $total_records; ?> entries
                </div>
                <nav class="flex space-x-2">
                    <?php if ($page > 1): ?>
                        <a href="?page=<?php echo $page - 1; ?>&limit=<?php echo $limit; ?>" class="bg-gray-200 hover:bg-gray-300 text-gray-600 px-3 py-2 rounded text-xs">Previous</a>
                    <?php endif; ?>

                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?php echo $i; ?>&limit=<?php echo $limit; ?>" class="<?php echo $i == $page ? 'bg-blue-500 hover:bg-blue-600 text-white' : 'bg-gray-200 hover:bg-gray-300 text-gray-600'; ?> px-3 py-2 rounded text-xs"><?php echo $i; ?></a>
                    <?php endfor; ?>

                    <?php if ($page < $total_pages): ?>
                        <a href="?page=<?php echo $page + 1; ?>&limit=<?php echo $limit; ?>" class="bg-gray-200 hover:bg-gray-300 text-gray-600 px-3 py-2 rounded text-xs">Next</a>
                    <?php endif; ?>
                </nav>
            </div>

        </div>
    </div>


    <?php include 'includes/footer.php'; ?>