<?php
//require_once 'includes/setup.php';
include 'includes/header.php';
include "fungsi.php";
?>

<!-- Hero Section 
<div class="relative h-[500px] bg-gradient-to-r from-blue-900 to-blue-700">
  <div class="absolute inset-0 bg-black opacity-50"></div>
  <div class="relative container mx-auto px-4 h-full flex items-center">
    <div class="text-white max-w-2xl">
      <h1 class="text-4xl md:text-5xl font-bold mb-4">
        Lembaga Penjaminan Mutu
      </h1>
      <p class="text-xl mb-8">
        Menjamin dan meningkatkan mutu pendidikan tinggi secara berkelanjutan
      </p>
      <a href="kebijakan.php" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg inline-flex items-center">
        Selengkapnya
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 w-4 h-4">
          <path d="m9 18 6-6-6-6" />
        </svg>
      </a>
    </div>
  </div>
</div>-->

<!-- Slider Section -->
<div class="swiper-container relative h-[400px]">
  <div class="swiper-wrapper">
    <div class="swiper-slide">
      <img src="img/header0.jpg" alt="Gambar 1">
    </div>
    <div class="swiper-slide">
      <img src="img/header1.jpg" alt="Gambar 2">
    </div>
    <div class="swiper-slide">
      <img src="img/header2.jpg" alt="Gambar 3">
    </div>
  </div>
  <!-- Add Pagination -->
  <div class="swiper-pagination"></div>
  <!-- Add Navigation -->
  <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div>
</div>

<!-- Swiper JS Initialization -->
<script>
  var swiper = new Swiper('.swiper-container', {
    loop: true,
    pagination: {
      el: '.swiper-pagination',
      clickable: true,
    },
    navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
    },
  });
</script>

<!-- Features -->
<div class="py-16 bg-gray-50">
  <div class="container mx-auto px-4">
    <div class="grid md:grid-cols-3 gap-8"><a href="penetapan.php">
        <div class="bg-white p-6 rounded-lg shadow-md">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12 text-blue-600 mb-4">
            <path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z" />
            <polyline points="14 2 14 8 20 8" />
          </svg>
          <h3 class="text-xl font-semibold mb-2">Dokumen Mutu</h3>
          <p class="text-gray-600">Akses dokumen standar mutu, manual prosedur, dan instruksi kerja</p>
        </div>
      </a>
      <div class="bg-white p-6 rounded-lg shadow-md"><a href="ami.php">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12 text-blue-600 mb-4">
            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2" />
            <circle cx="9" cy="7" r="4" />
            <path d="M22 21v-2a4 4 0 0 0-3-3.87" />
            <path d="M16 3.13a4 4 0 0 1 0 7.75" />
          </svg>
          <h3 class="text-xl font-semibold mb-2">Audit Internal</h3>
          <p class="text-gray-600">Pelaksanaan audit mutu internal secara berkala</p>
      </div></a>
      <div class="bg-white p-6 rounded-lg shadow-md"><a href="pengendalian.php">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-12 h-12 text-blue-600 mb-4">
            <circle cx="11" cy="11" r="8" />
            <path d="m21 21-4.3-4.3" />
          </svg>
          <h3 class="text-xl font-semibold mb-2">Monitoring & Evaluasi</h3>
          <p class="text-gray-600">Pemantauan dan evaluasi implementasi sistem penjaminan mutu</p>
      </div></a>
    </div>
  </div>
</div>

<!-- Recent News -->
<div class="py-16">
  <div class="container mx-auto px-4">
    <h2 class="text-3xl font-bold mb-8 text-center">Berita Terkini</h2>
    <div class="grid md:grid-cols-3 gap-8">
      <?php
      $query = "
      SELECT news.*, users.name AS author_name 
      FROM news 
      JOIN users ON news.author_id = users.id
      order by id desc limit 6";
      $news = $conn->query($query);
      if ($news->num_rows == 0) {
        // Jika tidak ada data ditemukan
        echo "<div class='alert alert-warning' role='alert'>Data belum ada.</div>";
      } else {
        while ($item = $news->fetch_assoc()) {

          /* $news = [
        [
          'image' => 'https://source.unsplash.com/random/800x600?education=1',
          'title' => 'Workshop Penjaminan Mutu',
          'excerpt' => 'Pelatihan dan pengembangan sistem penjaminan mutu internal kampus'
        ],
        [
          'image' => 'https://source.unsplash.com/random/800x600?education=2',
          'title' => 'Audit Mutu Internal 2024',
          'excerpt' => 'Pelaksanaan audit mutu internal untuk peningkatan kualitas pendidikan'
        ],
        [
          'image' => 'https://source.unsplash.com/random/800x600?education=3',
          'title' => 'Evaluasi Semester Ganjil',
          'excerpt' => 'Hasil evaluasi pembelajaran semester ganjil tahun akademik 2023/2024'
        ]
      ];*/

          //foreach ($data as $item) { 
          $konten = $item['content'];

          // Pisahkan gambar dan teks menggunakan regex
          preg_match('/<img[^>]+src="([^"]+)"[^>]*>/i', $konten, $match);
          $gambar = $match[1] ?? ''; // Ambil URL gambar atau kosong jika tidak ditemukan

          // Hapus tag gambar dari konten
          $teks = preg_replace('/<img[^>]*>/', '', $konten);
          $teks_sebagian = substr(strip_tags($teks), 0, 100); // Hilangkan tag HTML
      ?>
          <div class="bg-white rounded-lg overflow-hidden shadow-md">
            <img
              src="<?php echo $gambar;
                    ?>"
              alt="<?php echo $item['title'];
                    ?>"
              class="w-full h-48 object-cover" />

            <div class="p-6">
              <div class="flex items-center justify-between mb-2">
                <span class="text-sm text-blue-600 font-medium"><?php echo $item['author_name'];
                                                                ?></span>
                <span class="text-sm text-gray-500"><?php echo $item['created_at']; ?></span>
              </div>
              <h3 class="text-xl font-semibold mb-2"><?php echo $item['title']; ?></h3>
              <p class="text-gray-600 mb-4"><?php echo $teks_sebagian;
                                            ?></p>
              <a href="detail.php?id=<?= $item['id'] ?>" class="text-blue-600 hover:text-blue-700 inline-flex items-center">
                Baca selengkapnya
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 w-4 h-4">
                  <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6" />
                  <polyline points="15 3 21 3 21 9" />
                  <line x1="10" x2="21" y1="14" y2="3" />
                </svg>
              </a>
            </div>
          </div>
      <?php }
      } ?>
    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>