<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LPM ITB-RU - Lembaga Penjaminan Mutu</title>
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />

    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        /* Dropdown hover effect */
        .dropdown:hover .dropdown-menu {
            display: block;
        }

        .dropdown-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            min-width: 150px;
            width: 100%;
            z-index: 50;
        }

        /* Ensure no gap between dropdown and submenu */
        .dropdown {
            position: relative;
        }

        .dropdown-menu a {
            display: block;
            padding: 8px 16px;
            white-space: nowrap;
        }
    </style>
</head>

<body class="min-h-screen bg-white">
    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <!-- Header -->
    <header class="bg-blue-900 text-white">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <div class="flex items-center space-x-2">
                    <img src="img/1634.jpg" width="24" height="24">
                    <div>
                        <h1 class="text-xl font-bold">LPM ITB-RU</h1>
                        <p class="text-sm">Lembaga Penjaminan Mutu</p>
                    </div>
                </div>
                <div class="hidden md:flex items-center space-x-6">
                    <a href="index.php" class="hover:text-blue-200">Home</a>
                    <a href="berita.php" class="hover:text-blue-200">Berita</a>
                    <div class="dropdown">
                        <a href="#" class="hover:text-blue-200 flex items-center">
                            Siklus PPEPP
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1">
                                <path d="m6 9 6 6 6-6" />
                            </svg>
                        </a>
                        <div class="dropdown-menu bg-white text-gray-700 rounded-md shadow-lg">
                            <a href="penetapan.php" class="hover:bg-gray-100">Penetapan</a>
                            <a href="pelaksanaan.php" class="hover:bg-gray-100">Pelaksanaan</a>
                            <a href="evaluasi.php" class="hover:bg-gray-100">Evaluasi</a>
                            <a href="pengendalian.php" class="hover:bg-gray-100">Pengendalian</a>
                            <a href="peningkatan.php" class="hover:bg-gray-100">Peningkatan</a>
                        </div>
                    </div>
                    <a href="dashboard/" class="hover:text-blue-200">Login</a>
                </div>
                <button class="md:hidden" onclick="toggleMenu()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="4" x2="20" y1="12" y2="12" />
                        <line x1="4" x2="20" y1="6" y2="6" />
                        <line x1="4" x2="20" y1="18" y2="18" />
                    </svg>
                </button>
            </div>
            <!-- Mobile Menu -->
            <div id="mobileMenu" class="hidden md:hidden pb-4">
                <nav class="flex flex-col space-y-2">
                    <a href="index.php" class="hover:text-blue-200">Home</a>
                    <a href="berita.php" class="hover:text-blue-200">Berita</a>
                    <div class="relative">
                        <button onclick="toggleSubmenu()" class="hover:text-blue-200 flex items-center">
                            Siklus PPEPP
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="w-4 h-4 ml-1">
                                <path d="m6 9 6 6 6-6" />
                            </svg>
                        </button>
                        <div id="mobileSubmenu" class="hidden flex flex-col mt-2 space-y-2 bg-white text-gray-700 rounded-md shadow-lg">
                            <a href="penetapan.php" class="hover:bg-gray-100">Penetapan</a>
                            <a href="pelaksanaan.php" class="hover:bg-gray-100">Pelaksanaan</a>
                            <a href="evaluasi.php" class="hover:bg-gray-100">Evaluasi</a>
                            <a href="pengendalian.php" class="hover:bg-gray-100">Pengendalian</a>
                            <a href="peningkatan.php" class="hover:bg-gray-100">Peningkatan</a>
                        </div>
                    </div>
                    <a href="dashboard/" class="hover:text-blue-200">Login</a>
                </nav>
            </div>
        </div>
    </header>
    <script>
        function toggleMenu() {
            const menu = document.getElementById('mobileMenu');
            menu.classList.toggle('hidden');
        }

        function toggleSubmenu() {
            const submenu = document.getElementById('mobileSubmenu');
            submenu.classList.toggle('hidden');
        }
    </script>