<?php
require "config.php";

// Fungsi CRUD dinamis
function executeQuery($conn, $query, $types = "", $params = [])
{
    $stmt = $conn->prepare($query);
    if ($types && $params) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    return $stmt;
}
//untuk menambahkan data yang diambil dari form
function tambahData($conn, $table, $columns, $values)
{
    $colStr = implode(", ", $columns);
    $placeholders = implode(", ", array_fill(0, count($values), "?"));
    $query = "INSERT INTO $table ($colStr) VALUES ($placeholders)";
    return executeQuery($conn, $query, str_repeat("s", count($values)), $values);
}
//untuk merubah data dari form
function editData($conn, $table,    $columns,    $values,    $idColumn,    $idValue)
{
    $setClause = implode(", ", array_map(fn($col) => "$col = ?", $columns));
    $query = "UPDATE $table SET $setClause WHERE $idColumn = ?";
    $values[] = $idValue;
    return executeQuery($conn, $query, str_repeat("s", count($columns)) . "i", $values);
}
//hapus data dengan primary key bertipe integer
function hapusDataInt($conn, $table, $idColumn, $idValue)
{
    $query = "DELETE FROM $table WHERE $idColumn = ?";
    return executeQuery($conn, $query, "i", [$idValue]);
}
//hapus data dengan primary key bertipe string
function hapusDataString($conn, $table, $idColumn, $idValue)
{
    $query = "DELETE FROM $table WHERE $idColumn = ?";
    return executeQuery($conn, $query, "s", [$idValue]);
}
//untuk mengambil data dari tabel baik dengan filter atau tanpa filter
function ambilData($conn, $table, $idColumn = null, $idValue = null, $column = null, $value = null)
{
    if ($idValue) {
        $query = "SELECT * FROM $table WHERE $idColumn = ?";
        $stmt = executeQuery($conn, $query, "i", [$idValue]);
        return $stmt->get_result()->fetch_assoc();
    } elseif ($value) {
        $query = "SELECT * FROM $table WHERE $column = ?";
        $stmt = executeQuery($conn, $query, "s", [$value]);
        return $stmt->get_result()->fetch_assoc();
    } else {
        $query = "SELECT * FROM $table";
        return $conn->query($query);
    }
}
/*
function ambilData($conn, $table, $column = null, $value = null)
{
    if ($column && $value !== null) {
        // Menentukan tipe parameter berdasarkan jenis nilai (integer atau string)
        $paramType = is_int($value) ? "i" : "s";  // "i" untuk integer, "s" untuk string

        // Query untuk mencari berdasarkan kolom dan nilai
        $query = "SELECT * FROM $table WHERE $column = ?";
        $stmt = executeQuery($conn, $query, $paramType, [$value]);

        // Mengambil hasil query
        return $stmt->get_result()->fetch_assoc();
    } else {
        // Jika tidak ada kolom dan nilai yang dicari, ambil semua data
        $query = "SELECT * FROM $table";
        return $conn->query($query);
    }
}

function ambilData($conn, $table, $column = null, $value = null)
{
    if ($column && $value !== null) {
        // Menentukan tipe parameter berdasarkan jenis nilai (integer atau string)
        $paramType = is_int($value) ? "i" : "s";  // "i" untuk integer, "s" untuk string

        // Query untuk mencari berdasarkan kolom dan nilai
        $query = "SELECT * FROM $table WHERE $column = ?";
        $stmt = $conn->prepare($query); // Memastikan menggunakan prepare()

        if ($stmt === false) {
            // Jika prepare gagal, kembalikan error
            die('Error in query preparation: ' . $conn->error);
        }

        // Menyusun parameter
        $stmt->bind_param($paramType, $value);

        // Menjalankan query
        $stmt->execute();

        // Mengecek apakah query berhasil dieksekusi
        $result = $stmt->get_result();
        if ($result === false) {
            // Jika get_result() gagal, kembalikan error
            die('Error in fetching result: ' . $stmt->error);
        }

        return $result->fetch_assoc();
    } else {
        // Jika tidak ada kolom dan nilai yang dicari, ambil semua data
        $query = "SELECT * FROM $table";
        return $conn->query($query);
    }
}
*/
function ambilDokumenBerdasarkanJenis($conn, $jenis_dokumen)
{
    $query = "SELECT * FROM dokumen WHERE jenis_dokumen = ?";
    $stmt = $conn->prepare($query);

    // Bind parameter
    $stmt->bind_param("s", $jenis_dokumen);

    // Eksekusi query
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->get_result();

    // Cek apakah hasil query kosong
    if ($result->num_rows === 0) {
        return null; // Tidak ada data ditemukan
    }

    // Kembalikan hasil dalam bentuk array asosiatif
    return $result->fetch_all(MYSQLI_ASSOC);
}
