<?php require "../fungsi.php"; ?>

<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Data Users</h1>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <!-- Tombol Tambah Data -->
                <a href="?page=add_user" class="btn btn-success mb-3">
                    <i class="fas fa-plus"></i> Tambah Data
                </a>
            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Created At</th>
                            <th>Updated At</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Created At</th>
                            <th>Updated At</th>
                            <th>Aksi</th>
                        </tr>
                    </tfoot>
                    <tbody>
                        <?php
                        if (isset($_GET['id'])) {
                            $id = $_GET['id'];
                            $table = "users"; // Nama tabel
                            $idColumn = "id"; // Kolom ID di tabel
                            if (hapusDataInt($conn, $table, $idColumn, $id)) {
                                echo "<div class='alert alert-success' role='alert'>Data berhasil dihapus.</div>";
                            } else {
                                echo "<div class='alert alert-danger' role='alert'>Data gagal dihapus!</div>";
                            }
                        }

                        // Ambil data dari tabel users
                        $users = ambilData($conn, "users");

                        if ($users === null) {
                            // Jika tidak ada data ditemukan
                            echo "<div class='alert alert-warning' role='alert'>Data belum ada.</div>";
                        } else {
                            $no = 1;
                            foreach ($users as $row) {
                        ?>
                                <tr>
                                    <td><?= $no ?></td>
                                    <td><?= $row['name'] ?></td>
                                    <td><?= $row['email'] ?></td>
                                    <td><?= ucfirst($row['role']) ?></td>
                                    <td><?= $row['created_at'] ?></td>
                                    <td><?= $row['updated_at'] ?></td>
                                    <td>
                                        <a href="?page=edit_user&id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="?page=users&id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus user ini?')">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                        <?php
                                $no++;
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->