<?php

include '../config.php';

// Pastikan user telah login
if (!isset($_SESSION['email'])) {
    header("Location: login.php");
    exit();
}

// Ambil data user dari database
$user_id = $_SESSION['user_id'];
$query = "SELECT * FROM users WHERE id = '$user_id'";
$result = $conn->query($query);

if ($result->num_rows == 1) {
    $user = $result->fetch_assoc();
} else {
    $_SESSION['error'] = "Gagal memuat profil.";
    header("Location: index.php");
    exit();
}

// Update nama
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_name'])) {
    $new_name = $conn->real_escape_string($_POST['name']);
    $update_query = "UPDATE users SET name = '$new_name' WHERE id = '$user_id'";
    if ($conn->query($update_query)) {
        $_SESSION['nama'] = $new_name; // Perbarui sesi nama
        $_SESSION['success'] = "Nama berhasil diperbarui.";
    } else {
        $_SESSION['error'] = "Gagal memperbarui nama.";
    }
    header("Location: profile.php");
    exit();
}

// Update password
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = password_hash($_POST['new_password'], PASSWORD_BCRYPT);

    // Verifikasi password lama
    if (password_verify($current_password, $user['password'])) {
        $update_query = "UPDATE users SET password = '$new_password' WHERE id = '$user_id'";
        if ($conn->query($update_query)) {
            $_SESSION['success'] = "Password berhasil diperbarui.";
        } else {
            $_SESSION['error'] = "Gagal memperbarui password.";
        }
    } else {
        $_SESSION['error'] = "Password lama salah.";
    }
    header("Location: profile.php");
    exit();
}
?>



<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Informasi Akun</h1>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <h1>Profil User</h1>
            <?php if (isset($_SESSION['error'])): ?>
                <p style="color: red;"><?php echo $_SESSION['error'];
                                        unset($_SESSION['error']); ?></p>
            <?php endif; ?>

            <?php if (isset($_SESSION['success'])): ?>
                <p style="color: green;"><?php echo $_SESSION['success'];
                                            unset($_SESSION['success']); ?></p>
            <?php endif; ?>

            <p><strong>Nama:</strong> <?php echo htmlspecialchars($user['name']); ?></p>
            <p><strong>Email:</strong> <?php echo htmlspecialchars($user['email']); ?></p>
            <p><strong>Role:</strong> <?php echo htmlspecialchars($user['role']); ?></p>

            <h2>Perbarui Nama</h2>
            <form action="profile.php" method="POST">
                <label for="name">Nama Baru:</label>
                <input type="text" name="name" id="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
                <button type="submit" name="update_name">Perbarui Nama</button>
            </form>

            <h2>Perbarui Password</h2>
            <form action="profile.php" method="POST">
                <label for="current_password">Password Lama:</label>
                <input type="password" name="current_password" id="current_password" required>

                <label for="new_password">Password Baru:</label>
                <input type="password" name="new_password" id="new_password" required>

                <button type="submit" name="update_password">Perbarui Password</button>
            </form>
        </div>
    </div>

</div>
<!-- /.container-fluid -->