<?php require "../fungsi.php";

?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Data Berita</h1>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <!-- Tombol Tambah Data -->
                <a href="?page=add_news" class="btn btn-success mb-3">
                    <i class="fas fa-plus"></i> Tambah Data
                </a>
            </h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">

                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Judul</th>
                            <th>Penulis</th>
                            <th>Waktu Dibuat</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>No</th>
                            <th>Judul</th>
                            <th>Penulis</th>
                            <th>Waktu Dibuat</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </tfoot>
                    <tbody>
                        <?php
                        //if (isset($_GET['id'])) {
                        if (isset($_GET['action']) && isset($_GET['id'])) {
                            $id = $_GET['id'];
                            $action = $_GET['action']; // Aksi: approve atau reject

                            // Tentukan status berdasarkan aksi
                            $status = ($action == 'approve') ? 'approved' : (($action == 'reject') ? 'rejected' : '');

                            if ($status) {
                                // Update status berita di database
                                $query = "UPDATE news SET status = ? WHERE id = ?";
                                $success = executeQuery($conn, $query, "si", [$status, $id]);

                                if ($success) {
                                    echo "<script>alert('Status berita berhasil diubah menjadi $status!'); window.location.href = '?page=news';</script>";
                                } else {
                                    echo "<div class='alert alert-danger' role='alert'>Gagal mengubah status berita!</div>";
                                }
                            } else {
                                echo "<div class='alert alert-warning' role='alert'>Aksi tidak valid!</div>";
                            }
                            if ($action == 'del') {
                                $table = "news"; // Nama tabel
                                $idColumn = "id"; // Kolom ID di tabel
                                if (hapusDataInt($conn, $table, $idColumn, $id)) {
                                    echo "<script>alert('Data berhasil dihapus!'); window.location.href = '?page=news';</script>";
                                } else {
                                    echo "<div class='alert alert-danger' role='alert'>Data gagal dihapus!</div>";
                                }
                            }
                        }

                        // Ambil semua data dari tabel news dengan join ke tabel users
                        $query = "
SELECT news.*, users.name AS author_name 
FROM news 
JOIN users ON news.author_id = users.id
";
                        $news = $conn->query($query);

                        if ($news->num_rows == 0) {
                            // Jika tidak ada data ditemukan
                            echo "<div class='alert alert-warning' role='alert'>Data belum ada.</div>";
                        } else {
                            $no = 1;
                            while ($row = $news->fetch_assoc()) {
                        ?>
                                <tr>
                                    <td><?= $no ?></td>
                                    <td><?= htmlspecialchars($row['title']) ?></td>
                                    <td><?= htmlspecialchars($row['author_name']) ?></td> <!-- Menampilkan nama author -->
                                    <td><?= htmlspecialchars($row['created_at']) ?></td>
                                    <td><?= ucfirst(htmlspecialchars($row['status'])) ?></td>
                                    <td>
                                        <a href="?page=edit_news&id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="?page=news&action=del&id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus berita ini?')">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <a href="../detail.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php if ($row['status'] == 'pending') { ?>
                                            <a href="?page=news&action=approve&id=<?= $row['id'] ?>" class="btn btn-success btn-sm" onclick="return confirm('Setujui berita ini?')">
                                                <i class="fas fa-check"></i>
                                            </a>
                                            <a href="?page=news&action=reject&id=<?= $row['id'] ?>" class="btn btn-secondary btn-sm" onclick="return confirm('Tolak berita ini?')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        <?php } ?>
                                    </td>
                                </tr>
                        <?php
                                $no++;
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->