<?php
require "../fungsi.php";

if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Ambil data pengguna berdasarkan ID
    $query = "SELECT * FROM users WHERE id = ?";
    $stmt = executeQuery($conn, $query, "i", [$id]);
    $user = $stmt->get_result()->fetch_assoc();

    if (!$user) {
        echo "<div class='alert alert-danger' role='alert'>User tidak ditemukan.</div>";
        exit;
    }
} else {
    echo "<div class='alert alert-danger' role='alert'>ID tidak disediakan.</div>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $name = stripslashes($_POST['name']);
    $username = stripslashes($_POST['username']);
    $email = stripslashes($_POST['email']);
    $role = stripslashes($_POST['role']);
    $updated_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data diupdate

    // Periksa apakah password akan diubah
    $password = $_POST['password'];
    $password_hashed = empty($password) ? $user['password'] : password_hash($password, PASSWORD_DEFAULT);

    // Update data dalam tabel users
    $query = "UPDATE users SET username=?,name = ?, email = ?, password = ?, role = ?, updated_at = ? WHERE id = ?";
    $params = [$username, $name, $email, $password_hashed, $role, $updated_at, $id];

    if (executeQuery($conn, $query, "ssssssi", $params)) {
        echo "<div class='alert alert-success' role='alert'>Data berhasil diperbarui. 
        <a href='?page=user'>Lihat data</a></div>";
    } else {
        echo "Gagal memperbarui data: " . $conn->error;
    }
}
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800">Update Data User</h1>

    <!-- Form Update User -->
    <form action="" method="POST">
        <div class="form-group">
            <label for="name">Nama</label>
            <input type="text" class="form-control" id="name" name="name" value="<?= $user['name'] ?>" required>
        </div>
        <div class="form-group">
            <label for="name">Username</label>
            <input type="text" class="form-control" id="username" name="username" value="<?= $user['username'] ?>" required>
        </div>
        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" class="form-control" id="email" name="email" value="<?= $user['email'] ?>" required>
        </div>
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" class="form-control" id="password" name="password" placeholder="Kosongkan jika tidak ingin mengubah password">
        </div>
        <div class="form-group">
            <label for="role">Role</label>
            <select class="form-control" id="role" name="role" required>
                <option value="admin" <?= $user['role'] == 'admin' ? 'selected' : '' ?>>Admin</option>
                <option value="staff" <?= $user['role'] == 'staff' ? 'selected' : '' ?>>Staff</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </form>

</div>
<!-- /.container-fluid -->