<?php
require "../fungsi.php";

// Ambil ID dokumen dari parameter URL
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Ambil data dokumen yang akan diedit
$query = "SELECT * FROM dokumen WHERE id = ?";
$stmt = executeQuery($conn, $query, "i", [$id]);
$docData = $stmt->get_result()->fetch_assoc();

if (!$docData) {
    echo "<div class='alert alert-danger' role='alert'>Data dokumen tidak ditemukan!</div>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $nama_dokumen = stripslashes($_POST['nama_dokumen']);
    $deskripsi_dokumen = stripslashes($_POST['deskripsi_dokumen']);
    $level_dokumen = stripslashes($_POST['level_dokumen']);
    $tahun_terbit = stripslashes($_POST['tahun_terbit']);
    $link_dokumen = stripslashes($_POST['link_dokumen']);
    $updated_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data diperbarui
    $jenis = stripslashes($_POST['jenis']);

    // Validasi link dokumen (pastikan tidak ada duplikasi link dokumen pada dokumen lain)
    $query = "SELECT COUNT(*) AS count FROM dokumen WHERE link_dokumen = ? AND id != ?";
    $stmt = executeQuery($conn, $query, "si", [$link_dokumen, $id]);
    $result = $stmt->get_result()->fetch_assoc();

    if ($result['count'] > 0) {
        echo "<div class='alert alert-danger' role='alert'>Link dokumen sudah digunakan!</div>";
    } else {
        // Update data di tabel dokumen
        $query = "UPDATE dokumen SET level = ?,deskripsi = ?,nama_dokumen = ?, tahun_terbit = ?, link_dokumen = ?, updated_at = ? WHERE id = ?";
        if (executeQuery($conn, $query, "sssissi", [$level_dokumen, $deskripsi_dokumen, $nama_dokumen, $tahun_terbit, $link_dokumen, $updated_at, $id])) {
            //echo "<div class='alert alert-success' role='alert'>Data berhasil diperbarui. 
            //<a href='?page=penetapan'>Lihat data</a></div>";
            echo "<script>
            var jenis = '$jenis'; // Variabel PHP dimasukkan ke dalam JavaScript
            alert('Data berhasil diperbarui!');
            window.location.href = '?page=' + jenis;
          </script>";
        } else {
            echo "Gagal memperbarui data: " . $conn->error;
        }
    }
}
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800">Edit Data</h1>

    <!-- Form Edit Dokumen -->
    <form action="" method="POST">
        <div class="form-group">
            <label for="nama_dokumen">Nama Dokumen</label>
            <input type="text" class="form-control" id="nama_dokumen" name="nama_dokumen"
                value="<?= htmlspecialchars($docData['nama_dokumen']); ?>" required>
        </div>
        <div class="form-group">
            <label for="deskripsi_dokumen">Deskripsi Dokumen</label>
            <textarea class="form-control" id="deskripsi_dokumen" name="deskripsi_dokumen" rows="3" required><?php echo htmlspecialchars($docData['deskripsi']); ?></textarea>
        </div>
        <div class="form-group">
            <label for="level_dokumen">Level Dokumen</label>
            <select class="form-control" id="level_dokumen" name="level_dokumen" required>
                <option value="">Pilih Level</option>
                <option value="Institusi" <?php echo $docData['level'] === "Institusi" ? "selected" : ""; ?>>Institusi</option>
                <option value="Fakultas" <?php echo $docData['level'] === "Fakultas" ? "selected" : ""; ?>>Fakultas</option>
                <option value="Prodi" <?php echo $docData['level'] === "Prodi" ? "selected" : ""; ?>>Prodi</option>
            </select>
        </div>
        <div class="form-group">
            <label for="tahun_terbit">Tahun Terbit</label>
            <input type="number" class="form-control" id="tahun_terbit" name="tahun_terbit"
                value="<?= htmlspecialchars($docData['tahun_terbit']); ?>" required>
        </div>
        <div class="form-group">
            <label for="link_dokumen">Link Dokumen</label>
            <input type="text" class="form-control" id="link_dokumen" name="link_dokumen"
                value="<?= htmlspecialchars($docData['link_dokumen']); ?>" required>
            <input type="hidden" name="jenis" value="<?= htmlspecialchars($docData['jenis_dokumen']); ?>">
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Perbarui</button>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </form>

</div>
<!-- /.container-fluid -->