<?php
require "../fungsi.php";
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $name = stripslashes($_POST['name']);
    $username = stripslashes($_POST['username']);
    $email = stripslashes($_POST['email']);
    $password = password_hash(stripslashes($_POST['password']), PASSWORD_DEFAULT); // Hash password untuk keamanan
    $role = stripslashes($_POST['role']);
    $created_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan
    $updated_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan (update pertama kali)

    // Data yang ingin ditambahkan
    $table = "users"; // Nama tabel
    $columns = ["username", "name", "email", "password", "role", "created_at", "updated_at"]; // Kolom tabel
    $values = [$username, $name, $email, $password, $role, $created_at, $updated_at]; // Nilai untuk ditambahkan

    // Validasi username (pastikan tidak ada duplikasi username)
    $query = "SELECT COUNT(*) AS count FROM users WHERE username = ?";
    $stmt = executeQuery($conn, $query, "s", [$username]);
    $result2 = $stmt->get_result()->fetch_assoc();
    // Validasi email (pastikan tidak ada duplikasi email)
    $query = "SELECT COUNT(*) AS count FROM users WHERE email = ?";
    $stmt = executeQuery($conn, $query, "s", [$email]);
    $result = $stmt->get_result()->fetch_assoc();
    if ($result2['count'] > 0) {
        echo "<div class='alert alert-danger' role='alert'>Username sudah digunakan!</div>";
    } else if ($result['count'] > 0) {
        echo "<div class='alert alert-danger' role='alert'>Email sudah digunakan!</div>";
    } else {
        // Tambahkan data ke dalam tabel users
        if (tambahData($conn, $table, $columns, $values)) {
            echo "<div class='alert alert-success' role='alert'>Data berhasil ditambahkan. 
            <a href='?page=user'>Lihat data</a></div>";
        } else {
            echo "Gagal menambahkan data: " . $conn->error;
        }
    }
}
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800">Input Data User</h1>

    <!-- Form Input User -->
    <form action="" method="POST">
        <div class="form-group">
            <label for="name">Nama</label>
            <input type="text" class="form-control" id="name" name="name" required>
        </div>
        <div class="form-group">
            <label for="usrename">Username</label>
            <input type="text" class="form-control" id="username" name="username" required>
        </div>
        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" class="form-control" id="email" name="email" required>
        </div>
        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" class="form-control" id="password" name="password" required>
        </div>
        <div class="form-group">
            <label for="role">Role</label>
            <select class="form-control" id="role" name="role" required>
                <option value="admin">Admin</option>
                <option value="staff">Staff</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </form>

</div>
<!-- /.container-fluid -->