<?php
require "../fungsi.php";
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $nama_dokumen = stripslashes($_POST['nama_dokumen']);
    $tahun_terbit = stripslashes($_POST['tahun_terbit']);
    $link_dokumen = stripslashes($_POST['link_dokumen']);
    $jenis_dokumen = 'pelaksanaan'; // Jenis dokumen default adalah 'pelaksanaan'
    $created_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan
    $updated_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan (update pertama kali)

    // Data yang ingin ditambahkan
    $table = "dokumen"; // Nama tabel
    $columns = ["nama_dokumen", "tahun_terbit", "link_dokumen", "jenis_dokumen", "created_at", "updated_at"]; // Kolom tabel
    $values = ["$nama_dokumen", "$tahun_terbit", "$link_dokumen", "$jenis_dokumen", "$created_at", "$updated_at"]; // Nilai untuk ditambahkan

    // Validasi link dokumen (pastikan tidak ada duplikasi link dokumen)
    $query = "SELECT COUNT(*) AS count FROM dokumen WHERE link_dokumen = ?";
    $stmt = executeQuery($conn, $query, "s", [$link_dokumen]);
    $result = $stmt->get_result()->fetch_assoc();

    if ($result['count'] > 0) {
        echo "<div class='alert alert-danger' role='alert'>Link dokumen sudah digunakan!</div>";
    } else {
        // Tambahkan data ke dalam tabel dokumen
        if (tambahData($conn, $table, $columns, $values)) {
            echo "<div class='alert alert-success' role='alert'>Data berhasil ditambahkan. 
            <a href='?page=pelaksanaan'>Lihat data</a></div>";
        } else {
            echo "Gagal menambahkan data: " . $conn->error;
        }
    }
}
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800">Input Data Pelaksanaan</h1>

    <!-- Form Input Dokumen -->
    <form action="" method="POST">
        <div class="form-group">
            <label for="nama_dokumen">Nama Dokumen</label>
            <input type="text" class="form-control" id="nama_dokumen" name="nama_dokumen" required>
        </div>
        <div class="form-group">
            <label for="tahun_terbit">Tahun Terbit</label>
            <input type="number" class="form-control" id="tahun_terbit" name="tahun_terbit" required>
        </div>
        <div class="form-group">
            <label for="jenis_dokumen">Link Dokumen</label>
            <input type="text" class="form-control" id="link_dokumen" name="link_dokumen" required>
        </div>
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </form>

</div>
<!-- /.container-fluid -->