<?php
require "../fungsi.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Ambil data dari form
    $title = stripslashes($_POST['title']);
    $content = stripslashes($_POST['content']);
    $author_id = $_SESSION['user_id']; //intval($_POST['author_id']); // Konversi ke integer untuk keamanan
    if ($_SESSION['role'] == 'admin') {
        $status = 'approved'; // Status default adalah 'pending'
    } else {
        $status = 'pending'; // Status default adalah 'pending'
    }

    $created_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan
    $updated_at = date('Y-m-d H:i:s'); // Tanggal dan waktu saat data ditambahkan

    // Data yang ingin ditambahkan
    $table = "news"; // Nama tabel
    $columns = ["title", "content", "author_id", "status", "created_at", "updated_at"]; // Kolom tabel
    $values = ["$title", "$content", "$author_id", "$status", "$created_at", "$updated_at"]; // Nilai untuk ditambahkan

    // Validasi title berita (pastikan tidak ada duplikasi judul berita)
    $query = "SELECT COUNT(*) AS count FROM news WHERE title = ?";
    $stmt = executeQuery($conn, $query, "s", [$title]);
    $result = $stmt->get_result()->fetch_assoc();

    if ($result['count'] > 0) {
        echo "<div class='alert alert-danger' role='alert'>Judul berita sudah digunakan!</div>";
    } else {
        // Tambahkan data ke dalam tabel news
        if (tambahData($conn, $table, $columns, $values)) {
            echo "<div class='alert alert-success' role='alert'>Berita berhasil ditambahkan. 
            <a href='?page=news'>Lihat berita</a></div>";
        } else {
            echo "Gagal menambahkan berita: " . $conn->error;
        }
    }
}
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800">Tambah Berita</h1>

    <!-- Form Input Berita -->
    <form action="" method="POST">
        <div class="form-group">
            <label for="title">Judul Berita</label>
            <input type="text" class="form-control" id="title" name="title" required>
        </div>
        <div class="form-group">
            <label for="content">Isi Berita</label>
            <textarea class="form-control" id="content" name="content" rows="5" required></textarea>

        </div>
        <!--<div class="form-group">
            <label for="author_id">ID Penulis</label>
            <input type="number" class="form-control" id="author_id" name="author_id" required>
        </div>-->
        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Simpan</button>
        <a href="javascript:history.back()" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </form>


</div>
<!-- /.container-fluid -->
<!--<script src="https://cdn.tiny.cloud/1/j2ntfmgnjwvnjrvkb9u0nhv8n0swfgllrnrfhlgru5mi5res/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '#contentt', // ID dari textarea
        height: 300,
        plugins: 'advlist autolink link image lists charmap preview',
        toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | outdent indent | link image',
        menubar: false
    });
</script>
-->
<!-- Place the first <script> tag in your HTML's <head> -->
<script src="https://cdn.tiny.cloud/1/j2ntfmgnjwvnjrvkb9u0nhv8n0swfgllrnrfhlgru5mi5res/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

<!-- Place the following <script> and <textarea> tags your HTML's <body> -->
<!--
<script>
    tinymce.init({
        selector: 'textarea',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
    });
</script>
-->
<script>
    tinymce.init({
        selector: 'textarea',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
        setup: function(editor) {
            editor.on('change', function() {
                tinymce.triggerSave(); // Sinkronkan konten TinyMCE ke <textarea>
            });
        }
    });

    // Tambahkan listener untuk form submit
    document.querySelector('form').addEventListener('submit', function(e) {
        tinymce.triggerSave(); // Pastikan konten editor disimpan ke dalam <textarea>
    });
</script>