<?php
include 'includes/header.php';
include 'fungsi.php';
?>
<style>
    .berita {
        margin-bottom: 30px;
        border-bottom: 1px solid #ccc;
        padding-bottom: 15px;
    }

    .paging {
        text-align: center;
        margin-top: 20px;
    }

    .paging a {
        margin: 0 5px;
        padding: 5px 10px;
        border: 1px solid #ccc;
        text-decoration: none;
        color: #333;
    }

    .paging a.active {
        background-color: #007bff;
        color: white;
        border-color: #007bff;
    }
</style>
<div class="container mx-auto px-4 py-16">
    <h1 class="text-4xl font-bold mb-8">Berita</h1>

    <div class="grid md:grid-cols-3 gap-8">
        <?php
        // Konfigurasi paging
        $berita_per_halaman = 6; // Jumlah berita per halaman
        $halaman = isset($_GET['halaman']) ? (int)$_GET['halaman'] : 1; // Halaman saat ini
        $offset = ($halaman - 1) * $berita_per_halaman; // Offset data

        // Query untuk menghitung total berita
        $sql_total = "SELECT COUNT(*) AS total FROM news";
        $result_total = $conn->query($sql_total);
        $total_berita = $result_total->fetch_assoc()['total'];
        $total_halaman = ceil($total_berita / $berita_per_halaman); // Total halaman
        $query = "
        SELECT news.*, users.name AS author_name 
        FROM news 
        JOIN users ON news.author_id = users.id
        LIMIT $offset, $berita_per_halaman";
        $news = $conn->query($query);
        if ($news->num_rows == 0) {
            // Jika tidak ada data ditemukan
            echo "<div class='alert alert-warning' role='alert'>Data belum ada.</div>";
        } else {
            while ($item = $news->fetch_assoc()) {
                $konten = $item['content'];

                // Pisahkan gambar dan teks menggunakan regex
                preg_match('/<img[^>]+src="([^"]+)"[^>]*>/i', $konten, $match);
                $gambar = $match[1] ?? ''; // Ambil URL gambar atau kosong jika tidak ditemukan

                // Hapus tag gambar dari konten
                $teks = preg_replace('/<img[^>]*>/', '', $konten);
                $teks_sebagian = substr(strip_tags($teks), 0, 100); // Hilangkan tag HTML

        ?>
                <div class="bg-white rounded-lg overflow-hidden shadow-md">
                    <img
                        src="<?php echo $gambar ?>"
                        alt="<?php echo $item['title']; ?>"
                        class="w-full h-48 object-cover" />
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm text-blue-600 font-medium"><?php echo $item['author_name'];
                                                                            ?></span>
                            <span class="text-sm text-gray-500"><?php echo $item['created_at']; ?></span>
                        </div>
                        <h3 class="text-xl font-semibold mb-2"><?php echo $item['title']; ?></h3>
                        <p class="text-gray-600 mb-4"><?php echo $teks_sebagian; ?></p>
                        <a href="detail.php?id=<?= $item['id'] ?>" class="text-blue-600 hover:text-blue-700 inline-flex items-center">
                            Baca selengkapnya
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-2 w-4 h-4">
                                <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6" />
                                <polyline points="15 3 21 3 21 9" />
                                <line x1="10" x2="21" y1="14" y2="3" />
                            </svg>
                        </a>
                    </div>
                </div>
        <?php }
        } ?>
    </div>
    <div class="paging">
        <?php for ($i = 1; $i <= $total_halaman; $i++): ?>
            <a href="?halaman=<?php echo $i; ?>" class="<?php echo $halaman == $i ? 'active' : ''; ?>">
                <?php echo $i; ?>
            </a>
        <?php endfor; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>